% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states_from_coords.R
\name{states_from_coords}
\alias{states_from_coords}
\title{Extract state from coordinates}
\usage{
states_from_coords(
  occ,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  from = "all",
  state_column = "stateProvince",
  output_column = "state_xy",
  append_source = FALSE
)
}
\arguments{
\item{occ}{(data.frame) a dataset with occurrence records, preferably
standardized using \code{format_columns()}.}

\item{long}{(character) column name with longitude. Default is
'decimalLongitude'.}

\item{lat}{(character) column name with latitude. Default is
'decimalLatitude'.}

\item{from}{(character) whether to extract the state for all records ('all')
or only for records missing state information ('na_only'). If 'na_only',
you must provide the name of the column with state information. Default is
'all'.}

\item{state_column}{(character) the column name containing the state. Only
applicable if \code{from = na_only}. Default is NULL.}

\item{output_column}{(character) column name created in \code{occ} to store the
states extracted. Default is 'state_xy'.}

\item{append_source}{(logical) whether to create a new column in \code{occ} called
'state_source', which indicates whether the state was derived from
coordinates. Default is FALSE.}
}
\value{
The original \code{occ} data.frame with an additional column containing the
states extracted from coordinates.
}
\description{
Extracts the state for each occurrence record based on coordinates.
}
\details{
The states are extracted from coordinates using a map retrieved from
\code{rnaturalearthdata::states50}.
}
\examples{
# Import and standardize GBIF
data("occ_gbif", package = "RuHere") #Import data example
gbif_standardized <- format_columns(occ_gbif, metadata = "gbif")
gbif_states <- states_from_coords(occ = gbif_standardized)
}
