% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_bien.R
\name{flag_bien}
\alias{flag_bien}
\title{Identify records outside natural ranges according to BIEN}
\usage{
flag_bien(
  data_dir,
  occ,
  species = "species",
  long = "decimalLongitude",
  lat = "decimalLatitude",
  buffer = 10,
  progress_bar = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data_dir}{(character) \strong{Required} directory path where the \code{BIEN}
data is saved}

\item{occ}{(data.frame or data.table) a data frame containing the occurrence
records to be flagged. Must contain columns for species, longitude, and
latitude.}

\item{species}{(character) the name of the column in \code{occ} that contains the
species scientific names. Default is \code{"species"}.}

\item{long}{(character) the name of the column in \code{occ} that contains the
longitude values. Default is \code{"decimalLongitude"}.}

\item{lat}{(character) the name of the column in \code{occ} that contains the
latitude values. Default is \code{"decimalLatitude"}.}

\item{buffer}{(numeric) buffer distance (in kilometers) to be applied
around the region of distribution. Default is 20 km.}

\item{progress_bar}{(logical) whether to display a progress bar during
processing. If TRUE, the 'pbapply' package must be installed. Default is
\code{FALSE}.}

\item{verbose}{(logical) if \code{TRUE}, prints messages about the progress and
the number of species being checked. Default is \code{TRUE}.}
}
\value{
A \code{data.frame} that is the original \code{occ} data frame
augmented with a new column named \code{bien_flag}. This column is
logical (\code{TRUE}/\code{FALSE}) indicating whether the record falls
within the expected distribution (plus buffer) based on the \code{BIEN}
data. Records for species not found in the \code{BIEN} data will have
\code{NA} in the \code{bien_flag} column.
}
\description{
Flags (validates) occurrence records based on known distribution data
from the Botanical Information and Ecology Network (BIEN) data. This function
checks if an occurrence point for a given species falls within its documented
distribution, allowing for user-defined buffers around the region. Records
are flagged as valid (\code{TRUE}) if they fall inside the documented
distribution (plus optional buffer) for the species in the BIEN dataset.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Filter occurrences for golden trumpet tree
occ <- occurrences[occurrences$species == "Handroanthus serratifolius", ]
# Set folder where distributional datasets were saved
# Here, just a sample provided in the package
# You must run 'bien_here()' beforehand to download the necessary data files
dataset_dir <- system.file("extdata/datasets", package = "RuHere")

# Flag records using BIEN specialist information
occ_bien <- flag_bien(data_dir = dataset_dir, occ = occ)

}
