% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip.R
\name{fuzzy_coco_parsnip}
\alias{fuzzy_coco_parsnip}
\title{parsnip model function}
\usage{
fuzzy_coco_parsnip(
  mode = "unknown",
  params,
  engine = FUZZY_COCO_HYBRID_ENGINE,
  seed = sample.int(10^5, 1),
  verbose = FALSE
)
}
\arguments{
\item{mode}{the type of model, either \strong{classification} or \strong{regression}}

\item{params}{fuzzy coco parameters, as a recursive named list, cf \code{\link[=params]{params()}}}

\item{engine}{the fuzzy coco fit engine to use, one of \strong{rcpp} and \strong{hybrid}}

\item{seed}{the RNG seed to use (to fit the model)}

\item{verbose}{whether to be verbose}
}
\value{
a parsnip model
}
\description{
parsnip model function
}
\examples{
spec <- fuzzy_coco_parsnip("regression",  params = example_mtcars()$params, seed = 123)
fit <- spec |> parsnip::set_engine("hybrid") |> parsnip::fit(qsec ~ ., data = example_mtcars()$data)
}
