% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{normal_gamma}
\alias{normal_gamma}
\title{Normal-Gamma Prior for Unknown Mean and Variance}
\usage{
normal_gamma(mu0 = 0, kappa0 = 1, alpha0 = 1, beta0 = 1)
}
\arguments{
\item{mu0}{Prior mean for the mean parameter}

\item{kappa0}{Prior pseudo-observations for the mean (strength of prior)}

\item{alpha0}{Shape parameter for the precision (inverse variance)}

\item{beta0}{Rate parameter for the precision}
}
\value{
An object of class "regime_prior"
}
\description{
Creates a Normal-Gamma prior specification for data with unknown mean and
variance. This is conjugate for normal observations.
}
\details{
The Normal-Gamma prior places a joint distribution on (mu, tau) where tau = 1/sigma^2:

tau ~ Gamma(alpha0, beta0)
mu | tau ~ Normal(mu0, 1/(kappa0 * tau))

The prior mean of mu is mu0, and the prior mean of sigma^2 is beta0/(alpha0-1) for alpha0 > 1.
}
\examples{
prior <- normal_gamma()

prior <- normal_gamma(mu0 = 0, kappa0 = 10, alpha0 = 3, beta0 = 2)

}
