% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztbinom.R
\name{ztbinom}
\alias{ztbinom}
\alias{dztbinom}
\alias{pztbinom}
\alias{rztbinom}
\title{Zero-truncated Binomial distribution}
\usage{
dztbinom(x, size, prob, log = FALSE)

pztbinom(q, size, prob, lower.tail = TRUE, log.p = FALSE)

rztbinom(n, size, prob)
}
\arguments{
\item{x, q}{integer vector of counts}

\item{size}{number of trials}

\item{prob}{success probability in each trial}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dztbinom} gives the probability mass function, \code{pztbinom} gives the distribution function, and \code{rztbinom} generates random deviates.
}
\description{
Probability mass function, distribution function, and random generation for
the zero-truncated Binomial distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.

By definition, this distribution only has support on the positive integers (1, ..., size).
Any zero-truncated distribution is defined as
\deqn{P(X=x | X>0) = P(X=x) / (1 - P(X=0)),}
where \eqn{P(X=x)} is the probability mass function of the corresponding untruncated distribution.
}
\examples{
set.seed(123)
x <- rztbinom(1, size = 10, prob = 0.3)
d <- dztbinom(x, size = 10, prob = 0.3)
p <- pztbinom(x, size = 10, prob = 0.3)
}
