% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpsi.R
\name{bpsi}
\alias{bpsi}
\title{Bayesian Probabilistic Selection Index (BPSI)}
\usage{
bpsi(problist, increase = NULL, lambda = NULL, int, save.df = FALSE)
}
\arguments{
\item{problist}{A list of object of class \code{probsup}, obtained from the \link{prob_sup} function}

\item{increase}{Optional logical vector with size corresponding to the number of traits
of \code{problist}, in the same order.\code{TRUE} if the selection is for increasing the trait value, \code{FALSE} otherwise.
If not declared, \code{bpsi} will consider the information provided in \link{prob_sup}}

\item{lambda}{A numeric representing the weight of each trait. Defaults to 1 (equal weights).
The trait with more economic interest should be greater.}

\item{int}{A numeric representing the selection intensity (between 0 and 1), considering the selection index.}

\item{save.df}{Logical. Should the data frames be saved in the work directory?
\code{TRUE} for saving, \code{FALSE} (default) otherwise.}
}
\value{
The function returns an object of class \code{bpsi}, which contains two lists,
one with the BPSI- Bayesian Probabilistic Selection Index, and another with the original \code{data}-
with across-environments probabilities of superior performance for each trait.
}
\description{
This function estimates the genotype's merit for multiple traits using the
probabilities of superior performance across environments.
}
\details{
\itemize{\item Bayesian Probabilistic Selection Index}

\deqn{BPSI_i = \sum_{m=1}^{t} \frac{\gamma_{pt} -\gamma_{it} }{(1/\lambda_t)}}

where \eqn{\gamma_p} is the probability of superior performance of the worst genotype for the trait \eqn{t},
\eqn{\gamma} is the probability of superior performance of genotype \eqn{i} for trait \eqn{t},
\eqn{t} is the total number of traits evaluated,
\eqn{\left(m = 1, 2, ..., t \right)},
and \eqn{\lambda} is the weight for each trait \eqn{t}.

More details about the usage of \code{bpsi} can be found at \url{https://tiagobchagas.github.io/BPSI/}.
}
\examples{
\donttest{



mod = bayes_met(data = soy_pat,
                gen = "gen",
                loc = "env",
                repl = NULL,
                trait = "PH",
                reg = NULL,
                year = NULL,
                res.het = TRUE,
                iter = 2000, cores = 2, chain = 4)


mod2 = bayes_met(data = soy_pat,
                 gen = "gen",
                 loc = "env",
                 repl = NULL,
                 trait = "GY",
                 reg = NULL,
                 year = NULL,
                 res.het = TRUE,
                 iter = 2000, cores = 2, chain = 4)

mod3 = bayes_met(data = soy_pat,
                 gen = "gen",
                 loc = "env",
                 repl =  NULL,
                 trait = "NDM",
                 reg = NULL,
                 year = NULL,
                 res.het = TRUE,
                 iter = 2000, cores = 2, chain = 4)



models=list(mod,mod2,mod3)
names(models) <- c("PH","GY","NDM")
increase = c(FALSE,TRUE,FALSE)
names(increase) <- names(models)

probs = list()
for (i in names(models)) {
  outs <- extr_outs(model = models[[i]],
                    probs = c(0.05, 0.95),
                    verbose = TRUE)
  probs[[i]] <- prob_sup(
    extr = outs,
    int = .2,
    increase = increase[[i]],
    save.df = FALSE,
    verbose = TRUE
  )

}

index = bpsi(
  problist = probs,
  increase = increase,
  int = 0.1,
  lambda = c(1, 2, 1),
  save.df = FALSE
)
}
}
\references{
Chagas, J. T. B., Dias, K. O. G., Carneiro, V. Q., Oliveira, L. M. C., Nunes, N. X.,
Pereira Júnior, J. D., Carneiro, P. C. S., & Carneiro, J. E. S. (2025).
Bayesian probabilistic selection index in the selection of common bean families.
\emph{Crop Science}, 65(3). \doi{10.1002/CSC2.70072}
}
\seealso{
\code{\link[=plot.bpsi]{plot.bpsi()}}
}
\author{
José Tiago Barroso Chagas
}
