% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{plot.param_grid_result}
\alias{plot.param_grid_result}
\title{Plot Parameter Grid Results (1D/2D/3D and Facets)}
\usage{
\method{plot}{param_grid_result}(
  x,
  y = NULL,
  type = c("auto", "line", "heatmap", "surface", "slices", "surface_slices"),
  metric = NULL,
  params = NULL,
  fixed = list(),
  agg = c("mean", "median", "max"),
  na.rm = TRUE,
  palette = NULL,
  zlim = NULL,
  clip = c(0.02, 0.98),
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{param_grid_result}.}

\item{y}{Ignored.}

\item{type}{One of "auto","line","heatmap","surface","slices","surface_slices".}

\item{metric}{Column name to plot (defaults to "score" if present).}

\item{params}{Character vector of parameter columns to use for axes/facets.
If \code{NULL}, uses all parameter columns detected in \code{x$all_results}.}

\item{fixed}{Optional named list of parameter values to condition on.
Rows not matching are dropped before plotting.}

\item{agg}{Aggregation when multiple rows map to a cell:
"mean","median", or "max".}

\item{na.rm}{Logical; drop NA metric rows before plotting.}

\item{palette}{Optional color vector used for heatmaps/surfaces.
Defaults to \code{grDevices::hcl.colors(..., "YlOrRd", rev = TRUE)}.}

\item{zlim}{Optional two-element numeric range for color scaling.}

\item{clip}{Two quantiles used to winsorize z-limits for stable coloring.}

\item{main, sub, xlab, ylab}{Base plotting annotations.}

\item{...}{Additional options depending on \code{type}, e.g.:
\code{legend}, \code{label_cells}, \code{contour}, \code{mark_best},
\code{theta}, \code{phi}, \code{shade}, \code{expand}, \code{ticktype},
\code{shared_zlim}, \code{facet}, \code{facet_values}, \code{ncol},
\code{debug}, \code{impute_for_surface}.}
}
\value{
An invisible list describing the plot (kind/params/zlim/etc.).
}
\description{
Generic plotter for objects returned by \code{\link[=run_param_grid]{run_param_grid()}}. Supported types:
\itemize{
\item "line": 1D metric vs one parameter.
\item "heatmap": 2D heatmap over two parameters.
\item "surface": 3D surface (persp) over two parameters.
\item "slices": 2D heatmaps faceted by a third parameter.
\item "surface_slices": 3D surfaces faceted by a third parameter.
\item "auto": chosen from the above based on the number of parameters.
}
}
\examples{
\donttest{
  data(sample_prices_weekly)
  b <- function(prices, params, ...) {
    weight_equally(filter_top_n(calc_momentum(prices, params$lookback), 10))
  }
  opt <- run_param_grid(
    prices  = sample_prices_weekly,
    grid    = list(lookback = c(8, 12, 26)),
    builder = b
  )
  plot(opt, type = "line", params = "lookback")
}

}
\seealso{
\code{\link[=run_param_grid]{run_param_grid()}}, \code{\link[=print.param_grid_result]{print.param_grid_result()}}
}
