% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YI.R
\name{YI}
\alias{YI}
\title{Yield Index (YI)}
\usage{
YI(Gen, YS, YMS = NULL)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}

\item{YMS}{Optional numeric scalar: mean of \code{YS}. If NULL, computed.}
}
\value{
A list with \code{YMS} and \code{Result} (data frame with \code{Gen}, \code{YI}).

\deqn{YI = \frac{YS}{YMS}}
}
\description{
This function computes Yield Index (YI) using any traits (like yield) under stress and non-stress conditions. The lower values of YI indicates greater tolerance. For more details see Gavuzzi et al. (1997) \url{doi:10.4141/P96-130}.
}
\examples{
out = YI(Gen=c("G1","G2","G3"), YS=c(7,5,3))
print(out)
}
\references{
Gavuzzi, P., Rizza, F., Palumbo, M., Campanile, R.G., Ricciardi, G.L. and Borghi, B. (1997). Evaluation of field and laboratory predictors of drought and heat tolerance in winter cereals. Canadian Journal of Plant Science, 77(4), 523-531.
}
