% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\title{Calculate Trait Coverage Statistics}
\usage{
coverage(data)
}
\arguments{
\item{data}{A data frame containing trait data. Each column represents a trait
and each row represents an observation (e.g., species, samples).}
}
\value{
A data frame with the following columns:
  \describe{
    \item{Trait}{Character. Names of traits plus an "All" row for complete cases}
    \item{Available_count}{Integer. Number of non-missing values for each trait}
    \item{Missing_count}{Integer. Number of missing (NA) values for each trait}
    \item{Trait_coverage_rate}{Character. Percentage of available data for each trait}
  }
  The "All" row shows statistics for complete cases (rows with no missing values).
}
\description{
This function calculates comprehensive coverage statistics for trait data,
including individual trait coverage rates, complete case coverage, and overall
data coverage. It provides both summary statistics and detailed breakdowns
of missing and available data.
}
\details{
The function performs the following calculations:
\itemize{
  \item \strong{Individual trait coverage}: For each trait, calculates the number
    and percentage of available (non-NA) values
  \item \strong{Complete case coverage}: Counts rows with no missing values across
    all traits and calculates the percentage
  \item \strong{Overall coverage}: Calculates the percentage of all cells in the
    dataset that contain non-missing values
}

The function also prints the overall trait coverage rate to the console before
returning the detailed summary table.
}
\examples{
# Create sample trait data
trait_data <- data.frame(
  PlantHeight = c(1.2, 1.5, NA, 2.1, 1.8),
  LDMC = c(0.5, NA, 0.8, 1.2, 0.9),
  LA = c(15.2, 18.5, 12.3, NA, 16.7)
)

# Calculate coverage statistics
coverage(trait_data)

}
