% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_adjpin.R
\name{initials_adjpin_rnd}
\alias{initials_adjpin_rnd}
\title{AdjPIN random initial sets}
\usage{
initials_adjpin_rnd(data, restricted = list(), num_init = 20,
 verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{restricted}{A binary list that allows estimating restricted
AdjPIN models by specifying which model parameters are assumed to be equal.
It contains one or multiple of the following four elements
\verb{\{theta, mu, eps, d\}}. For instance, If \code{theta} is set to \code{TRUE},
then the probability of liquidity shock in no-information days, and in
information days is assumed to be the same (\thetaB\code{=}\thetaS). If any of
the remaining rate elements \verb{\{mu, eps, d\}} is set to \code{TRUE},
(say  \code{mu=TRUE}), then the rate is assumed to be the same on the buy side,
and on the sell side (\mub\code{=}\mus). If more than one element is set to
\code{TRUE}, then the restrictions are combined. For instance, if the argument
\code{restricted} is set to \code{list(theta=TRUE, eps=TRUE, d=TRUE)}, then the
restricted AdjPIN model is estimated, where \thetaB\code{=}\thetaS, \eb\code{=}\es,
and \Db\code{=}\Ds. If the value of the argument \code{restricted} is the empty list
(\code{list()}), then all parameters of the model are assumed to be independent,
and the unrestricted model is estimated. The default value is the empty
list \code{list()}.}

\item{num_init}{An integer corresponds to the number of initial
parameter sets to be generated. The default value is \code{20}.}

\item{verbose}{a binary variable that determines whether information messages
about the initial parameter sets, including the number of the initial
parameter sets generated. No message is shown when \code{verbose} is set to
\code{FALSE}. The default value is \code{TRUE}.}
}
\value{
Returns a dataframe of numerical vectors of ten elements
\{\eqn{\alpha}, \eqn{\delta}, \eqn{\theta}, \eqn{\theta'},
\eb, \es, \mub, \mus, \Db, \Ds\}.
}
\description{
Generates random initial parameter sets to be used in the estimation of the
\code{AdjPIN} model of \insertCite{Duarte09;textual}{PINstimation}.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.
\cr\cr The buy rate parameters \{\eb, \mub, \Db\} are randomly generated
from the interval (\code{minB}, \code{maxB}), where \code{minB} (\code{maxB}) is the smallest
(largest) value of buys in the dataset, under the condition that
\eb\code{+}\mub\code{+}\Db< \code{maxB}. Analogously, the sell rate parameters
\{\es, \mus, \Ds\} are randomly generated from the interval (\code{minS}, \code{maxS}),
where \code{minS} (\code{maxS}) is the smallest(largest) value of sells in the
dataset, under the condition that \es\code{+}\mus\code{+}\Ds < \code{maxS}.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Obtain a dataframe of 20 random initial parameters for the MLE of
# the AdjPIN model using the initials_adjpin_rnd().

initial.sets <- initials_adjpin_rnd(xdata, num_init = 20)

# Use the dataframe to estimate the AdjPIN model using the adjpin()
# function.

estimate <- adjpin(xdata, initialsets = initial.sets, verbose = FALSE)

# Show the value of adjusted PIN

show(estimate@adjpin)

}
\references{
\insertAllCited
}
