% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_surv_model_pred}
\alias{f_surv_model_pred}
\title{Predict from Survival Models}
\usage{
f_surv_model_pred(
  ngroups,
  time_pred,
  surv_model,
  spline_mod,
  cure_mod,
  group_names
)
}
\arguments{
\item{ngroups}{Integer. Number of groups.}

\item{time_pred}{Numeric vector of prediction times.}

\item{surv_model}{List of fitted survival models from \code{\link[=f_surv_model]{f_surv_model()}}.}

\item{spline_mod}{Logical. Whether spline models were fitted.}

\item{cure_mod}{Logical. Whether cure models were fitted.}

\item{group_names}{Character vector of group labels.}
}
\value{
A list of predictions containing:
\itemize{
\item \code{param_models}: Survival & hazard predictions for standard models.
\item \code{spline}: Predictions for spline models (if fitted).
\item \code{cure}: Predictions for cure models (if fitted).
}
}
\description{
Generates predicted survival and hazard values from fitted parametric,
spline, and cure models.
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
form <- stats::as.formula(survival::Surv(years, status) ~ group)
surv_model <- f_surv_model(
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  ngroups = nlevels(group),
  form = form,
  spline_mod = FALSE,
  cure_mod = FALSE,
  cure_link = "logistic",
  group_names = levels(group)
)
f_surv_model_pred(
  ngroups = nlevels(group),
  time_pred = seq(0, 5000, 365.25),
  surv_model = surv_model,
  spline_mod = FALSE,
  cure_mod = FALSE,
  group_names = levels(group)
)
}
