% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_diag_cure_surv_model}
\alias{f_plot_diag_cure_surv_model}
\title{Diagnostic Plot for Cure Survival Models}
\usage{
f_plot_diag_cure_surv_model(PERSUADE, model_index = 1)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}

\item{model_index}{Integer. Index of the cure model in
\code{PERSUADE$surv_pred$model$cure}.}
}
\value{
A base R diagnostic plot for the selected cure survival model.
}
\description{
Produces diagnostic plots for mixture and non-mixture cure survival models,
using transformations depending on the underlying distribution
(Weibull, log-normal, log-logistic).
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = TRUE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_diag_cure_surv_model(PERSUADE, model_index = 1)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
