% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob_utilities.R
\name{ob_gains_table_feature}
\alias{ob_gains_table_feature}
\title{Compute Gains Table for a Binned Feature Vector}
\usage{
ob_gains_table_feature(binned_df, target, group_var = "bin")
}
\arguments{
\item{binned_df}{A \code{data.frame} resulting from a binning transformation (e.g., via
\code{obwoe_apply}), containing at least the following columns:
\describe{
  \item{\code{feature}}{Original feature values (optional, for reference).}
  \item{\code{bin}}{Character vector of bin labels.}
  \item{\code{woe}}{Numeric vector of Weight of Evidence values.}
  \item{\code{idbin}}{Numeric vector of bin IDs (required for correct sorting).}
}}

\item{target}{A numeric vector of binary outcomes (0 for non-event, 1 for event).
Must have the same length as \code{binned_df}. Missing values are not allowed.}

\item{group_var}{Character string specifying the aggregation key. Options:
\itemize{
  \item \code{"bin"}: Group by bin label (default).
  \item \code{"woe"}: Group by WoE value.
  \item \code{"idbin"}: Group by bin ID.
}}
}
\value{
A \code{data.frame} containing the same extensive set of metrics as
  \code{\link{ob_gains_table}}, aggregated by \code{group_var} and sorted by \code{idbin}.
}
\description{
Calculates a full gains table by aggregating a raw binned dataframe against a
binary target. Unlike \code{\link{ob_gains_table}} which expects pre-aggregated counts,
this function takes observation-level data, aggregates it by the specified
group variable (bin, WoE, or ID), and then computes all statistical metrics.
}
\details{
\subsection{Aggregation and Sorting}{
The function first aggregates the binary target by the specified \code{group_var}.
Crucially, it uses the \code{idbin} column to sort the resulting groups. This ensures
that cumulative metrics (like KS and Gini) are calculated based on the logical
order of the bins (e.g., low score to high score), not alphabetical order.
}

\subsection{Advanced Metrics}{
In addition to standard credit scoring metrics, this function computes:
\itemize{
  \item \strong{Jensen-Shannon Divergence}: A symmetrized and smoothed version of
    KL divergence, useful for measuring stability between the bin distribution
    and the population distribution.
  \item \strong{F1-Score, Precision, Recall}: Treating each bin as a potential
    classification threshold.
}
}
}
\examples{
\donttest{
# Mock data representing a binned feature
df_binned <- data.frame(
  feature = c(10, 20, 30, 10, 20, 50),
  bin = c("Low", "Mid", "High", "Low", "Mid", "High"),
  woe = c(-0.5, 0.2, 1.1, -0.5, 0.2, 1.1),
  idbin = c(1, 2, 3, 1, 2, 3)
)
target <- c(0, 0, 1, 1, 0, 1)

# Calculate gains table grouped by bin ID
gt <- ob_gains_table_feature(df_binned, target, group_var = "idbin")

# Inspect key metrics
print(gt[, c("id", "count", "pos_rate", "lift", "js_divergence")])
}

}
\references{
Siddiqi, N. (2006). \emph{Credit Risk Scorecards: Developing and Implementing Intelligent Credit Scoring}. Wiley.

Kullback, S., & Leibler, R. A. (1951). On Information and Sufficiency.
\emph{The Annals of Mathematical Statistics}.
}
