% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Skewed.R
\name{sim.skewed}
\alias{sim.skewed}
\title{Simulates Data Sets from a Structural Equation Model (SEM) with Normal or Non-Normal Distributions}
\usage{
sim.skewed(
  nd = 10,
  ss = 100,
  fcors,
  loading,
  nonnormal = NULL,
  Fleishman = NULL,
  f.loc
)
}
\arguments{
\item{nd}{An integer, the number of data sets to be generated.}

\item{ss}{An integer, the sample size per data set (must be greater than 10).}

\item{fcors}{The factor correlation matrix, which must be symmetric. For one-factor models, this should be "matrix(1,1,1)".}

\item{loading}{The factor loading matrix. Columns correspond to factors, while non-zero rows specify the number of items associated with each factor.}

\item{nonnormal}{A numeric vector of 0s and 1s indicating whether each variable should be generated as normal (0) or non-normal (1).
If not specified, all variables are generated as normal.}

\item{Fleishman}{A numeric vector containing the coefficients B, C, and D from Fleishman’s power method. Note that A = –C.}

\item{f.loc}{File path indicating the directory where the generated data sets and auxiliary files will be saved.}
}
\description{
This function generates data sets based on a specified SEM.
The simulated data are organized such that the first column represents case identifiers, while the subsequent columns contain the simulated item responses.
For example, in a model with two factors and three items per factor, the column labels will follow the format: "ID, F1_x1, F1_x2, F1_x3, F2_x1, F2_x2, F2_x3".
The number of rows corresponds to the sample number of the data.
In addition to the generated data sets, two supplementary files are also saved:
(1) "Model_Info.dat" — containing the factor correlation matrix, factor loading matrix,
    a vector indicating non-normal items, and the coefficients B, C, and D from Fleishman’s power method (where A = –C).
(2) "Data_List.dat" — listing the names of all generated data files.
}
\examples{

fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.3,.3,.3,0,0,0,0,0,0,0,0,.4,.4))
ifN<-c(1,1,1,0,0,0,0,0)
fleis<-c(1.0174852, .190995, -.018577) # The coefficients for skewness = 1, kurtosis = 1

sim.skewed(nd=10, ss=100, fcors=fc,loading=fl, nonnormal = ifN, Fleishman = fleis, f.loc=tempdir())

}
\author{
Fatih Orçan
}
