% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_drug_products.R
\name{get_hc_drug_products}
\alias{get_hc_drug_products}
\title{Retrieve Drug Products from Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_drug_products(name = NULL)
}
\arguments{
\item{name}{Optional. A character string representing a partial
or complete name of the drug product to filter results.
If omitted, returns all available products.}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{drug_code}: Unique code identifying the drug product
  \item \code{class_name}: Class of drug (e.g., Human, Veterinary)
  \item \code{din}: Drug Identification Number (DIN)
  \item \code{brand_name}: Brand or trade name of the product
  \item \code{number_of_ais}: Number of active ingredients
  \item \code{ai_group_no}: Active ingredient group number
  \item \code{company_name}: Manufacturer name
  \item \code{last_update_date}: Date of last update in the database
}
}
\description{
Retrieves information on all drug products listed in the
Health Canada Drug Product Database (DPD) using the
RESTful API endpoint \code{/drug/drugproduct}.

Optionally, a partial product name can be provided to
filter the results to products that contain the search term
in their brand name.
}
\details{
This function sends a GET request to the Health Canada Drug Product Database API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

If the API request fails, returns no matches, or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada

  # Retrieve all products
  get_hc_drug_products()

  # Retrieve products matching a partial name
  get_hc_drug_products("acetaminophen")
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
