% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{reactions_drug_tbl_df}
\alias{reactions_drug_tbl_df}
\title{Drug Reactions}
\format{
A tibble with 69 observations and 6 variables:
\describe{
  \item{sequence}{Numeric variable indicating the order of the metabolic reaction}
  \item{left_drugbank_id}{Character variable with the DrugBank ID of the input compound}
  \item{left_drugbank_name}{Character variable with the name of the input compound}
  \item{right_drugbank_id}{Character variable with the DrugBank ID of the resulting metabolite}
  \item{right_drugbank_name}{Character variable with the name of the resulting metabolite}
  \item{parent_key}{Character variable for linking to external reference records}
}
}
\source{
Data taken from the covid19dbcand package version 0.1.1
}
\usage{
data(reactions_drug_tbl_df)
}
\description{
This dataset, reactions_drug_tbl_df, is a tibble containing detailed information on
69 biochemical reactions involving drug molecules. It includes enzyme-mediated
transformations, pharmacological activity of drug metabolites, and mappings between
substrates and products as described by DrugBank identifiers.
}
\details{
The dataset name has been kept as 'reactions_drug_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble data frame. The original content has not been modified
in any way.
}
