% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fda_adverse_events.R
\name{get_fda_adverse_events}
\alias{get_fda_adverse_events}
\title{Search Adverse Events by Drug Name in FDA Adverse Event Reporting System}
\source{
FDA Adverse Event Reporting System (FAERS) via openFDA:
\url{https://open.fda.gov/apis/drug/event/}
}
\usage{
get_fda_adverse_events(drug_name)
}
\arguments{
\item{drug_name}{A character string representing the name of the drug.}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{report_id}: Unique identifier for the adverse event report
  \item \code{date_received}: Date FDA received the report
  \item \code{country}: Country where event occurred
  \item \code{serious}: Is it serious? ("Yes", "No", or original API value / NA)
  \item \code{adverse_reactions}: List of adverse reactions reported (separated by semicolons) or NA
  \item \code{patient_sex}: Patient sex ("Male", "Female", "Unknown", original API value, or NA)
  \item \code{patient_age}: Patient age at onset (as returned by API) or NA
}
}
\description{
Retrieves adverse event reports from the FDA Adverse Event Reporting System (FAERS)
that match a specific drug name using the RESTful API endpoint
\code{/drug/event.json?search=<drug_name>}.

This includes details such as the safety report ID, receive date,
serious status, patient information, drug details, and adverse reactions
for each reported adverse event related to pharmaceutical products.
}
\details{
This function sends a GET request to the FDA openFDA API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

If the API request fails, returns no matches, or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # Esta función requiere conexión a internet y descarga datos de la FDA
  get_fda_adverse_events("aspirin")
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
