% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseMeasurementUse.R
\name{summariseMeasurementUse}
\alias{summariseMeasurementUse}
\title{Diagnostics of a codelist of measurement codes in the database}
\usage{
summariseMeasurementUse(
  cdm,
  codes,
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  dateRange = as.Date(c(NA, NA)),
  estimates = list(measurement_summary = c("min", "q25", "median", "q75", "max",
    "density"), measurement_value_as_number = c("min", "q01", "q05", "q25", "median",
    "q75", "q95", "q99", "max", "count_missing", "percentage_missing", "density"),
    measurement_value_as_concept = c("count", "percentage")),
  histogram = NULL,
  checks = c("measurement_summary", "measurement_value_as_number",
    "measurement_value_as_concept")
)
}
\arguments{
\item{cdm}{A reference to the cdm object.}

\item{codes}{A codelist of measurement/observation codes for which to perform
diagnostics.}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{dateRange}{Two dates. The first indicating the earliest measurement
date and the second indicating the latest possible measurement date.}

\item{estimates}{A named list indicating, for each measurement diagnostics
check, which estimates to retrieve. The names of the list should correspond
to the diagnostics checks, and each list element should be a character vector
specifying the estimates to compute.

Allowed estimates are those supported by the `summariseResult()` function in
the **PatientProfiles** package. If omitted, all available estimates for
each check will be returned.}

\item{histogram}{Named list where names point to checks for which to get
estimates for a histogram, and elements are numeric vectors indicating the
bind-width. See function examples. Histogram only available for
"measurement_summary" and "measurement_value_as_number".}

\item{checks}{Diagnostics to run. Options are: "measurement_summary",
"measurement_value_as_number", and "measurement_value_as_concept".}
}
\value{
A summarised result
}
\description{
Diagnostics of a codelist of measurement codes in the database
}
\examples{
\donttest{
library(MeasurementDiagnostics)

cdm <- mockMeasurementDiagnostics()

result <- summariseMeasurementUse(
  cdm = cdm, codes = list("test_codelist" = c(3001467L, 45875977L))
)

resultHistogram <- summariseMeasurementUse(
  cdm = cdm,
  codes = list("test_codelist" = c(3001467L, 45875977L)),
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  dateRange = as.Date(c(NA, NA)),
  estimates = list(
    "measurement_summary" = c("min", "q25", "median", "q75", "max", "density"),
    "measurement_value_as_number" = c(
      "min", "q01", "q05", "q25", "median", "q75", "q95", "q99", "max",
      "count_missing", "percentage_missing", "density"
    ),
    "measurement_value_as_concept" = c("count", "percentage")
  ),
  histogram = list(
    "time" = list(
      '0 to 100' = c(0, 100), '110 to 200' = c(110, 200),
      '210 to 300' = c(210, 300), '310 to Inf' = c(310, Inf)
    ),
    "measurements_per_subject" = list(
      '0 to 10' = c(0, 10), '11 to 20' = c(11, 20),
      '21 to 30' = c(21, 30), '31 to Inf' = c(31, Inf)
    ),
    "value_as_number" =  list(
      '0 to 5' = c(0, 5), '6 to 10' = c(6, 10),
      '11 to 15' = c(11, 15), '>15' = c(16, Inf)
    )
  ),
  checks = c("measurement_summary", "measurement_value_as_number", "measurement_value_as_concept")
)

CDMConnector::cdmDisconnect(cdm = cdm)
}

}
