% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRT.test.VLMR.R
\name{LRT.test.VLMR}
\alias{LRT.test.VLMR}
\title{Lo-Mendell-Rubin likelihood ratio test}
\usage{
LRT.test.VLMR(object1, object2)
}
\arguments{
\item{object1}{Fitted model object with fewer parameters (i.e., fewer \code{npar}, small model).}

\item{object2}{Fitted model object with more parameters (i.e., more \code{npar}, large model).}
}
\value{
An object of class \code{"htest"} containing:
\itemize{
\item \code{statistic}: VLMR adjusted test statistic
\item \code{parameter}: Degrees of freedom (\eqn{df = npar_2 - npar_1})
\item \code{p.value}: P-value from \eqn{\chi^2_df} distribution
\item \code{method}: Name of the test
\item \code{data.name}: Model comparison description
}
}
\description{
Implements the ad-hoc adjusted likelihood ratio test (LRT) described in Formula 15 of Lo, Mendell,
& Rubin (2001), also known as VLMR LRT (Vuong-Lo-Mendell-Rubin Adjusted LRT). This method is typically
used to compare models with \code{L-1} and \code{L} classes. If the difference in the number of
classes exceeds 1, conclusions should be interpreted with extreme caution.
}
\details{
Note that since the small model may be nested within the large model, the result
of \code{\link[LCPA]{LRT.test.VLMR}} may not be accurate and is provided for reference only.
More reliable conclusions should be based on a combination of fit indices (i.e., \code{\link[LCPA]{get.fit.index}}),
classification accuracy measures (i.e., \code{\link[LCPA]{get.entropy}}, \code{\link[LCPA]{get.AvePP}}), and a bootstrapped
likelihood-ratio test (i.e., BLRT, \code{\link[LCPA]{LRT.test.Bootstrap}}, which is very time-consuming).
Above all and the most important criterion, is that the better model is the one that aligns with theoretical
expectations and offers clear interpretability.

The \code{\link[LCPA]{LRT.test.VLMR}} statistic is defined as:
\deqn{VLMR = \frac{LRT}{c} \quad \text{where} \quad c = 1 + \frac{1}{df \cdot \log(N)}}
where:
\itemize{
\item \eqn{LRT} is the standard likelihood ratio statistic. see \code{\link[LCPA]{LRT.test}}
\item \eqn{df = npar_2 - npar_1} is the difference in number of free parameters between models.
\item \eqn{N} is the sample size.
}
Under the null hypothesis (\code{H_0}: small model is true), VLMR asymptotically follows
a chi-square distribution with \eqn{df} degrees of freedom.
}
\references{
Lo, Y., Mendell, N. R., & Rubin, D. B. (2001). Testing the number of components in a normal mixture. Biometrika, 88(3), 767-778. https://doi.org/10.1093/biomet/88.3.767

Nylund-Gibson, K., & Choi, A. Y. (2018). Ten frequently asked questions about latent class analysis. Translational Issues in Psychological Science, 4(4), 440-461. https://doi.org/10.1037/tps0000176
}
