% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_checks.R
\name{check_classes}
\alias{check_classes}
\title{Check classes of all variables used in the model}
\usage{
check_classes(data, fixed = NULL, random = NULL, auxvars = NULL,
  timevar = NULL, mess = TRUE)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{fixed}{a \code{formula}}

\item{random}{a \code{formula}}

\item{auxvars}{a one-sided \code{formula}}

\item{timevar}{a character string (name of the time variable, used in joint
models)}

\item{mess}{logical, if \code{TRUE} messages are printed}
}
\value{
nothing, but throws an error if a variable is of an unknown class
}
\description{
Runs a check that all variables that are used in the model are of a known
class (numeric, ordered, factor, logical, integer) so that type-appropriate
models can be specified.
Note: This function does not check the type of grouping variables, which
may be character strings.
}
\details{
used in model_imp (2020-06-09)
}
\keyword{internal}
