% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDInfer.R
\name{IBDInfer}
\alias{IBDInfer}
\title{Design-based Inference for Incomplete Block Designs}
\usage{
IBDInfer(y, b, z, g, w = c("Unit", "Block"), alpha = 0.05, data = NULL)
}
\arguments{
\item{y}{Observed outcomes.}

\item{b}{Block identifier (ID).}

\item{z}{Assigned treatments.}

\item{g}{A contrast vector, must sum to zero.}

\item{w}{A weight vector, must sum to one and contain non-negative values.}

\item{alpha}{Confidence level, default set to 0.05.}

\item{data}{A data frame; if provided, y, b, and z should be column names in the data frame.}
}
\value{
\code{IBDInfer} returns an object of class "IBD", which is a list containing the following components: :
\item{tau.ht}{The Horvitz-Thompson estimator of tau.}
\item{tau.haj}{The Hajek estimator of tau.}
\item{var_tau_ht_bb}{Variance estimator for the Horvitz-Thompson estimator with between-block bias.}
\item{var_tau_ht_wb}{Variance estimator for the Horvitz-Thompson estimator with within-block bias.}
\item{var_tau_haj_bb}{Variance estimator for the Hajek estimator with between-block bias.}
\item{var_tau_haj_wb}{Variance estimator for the Hajek estimator with within-block bias.}
\item{CI_ht_bb}{Confidence interval with the Horvitz-Thompson estimator and variance estimator with between-block bias.}
\item{CI_ht_wb}{Confidence interval with the Horvitz-Thompson estimator and variance estimator with within-block bias.}
\item{CI_haj_bb}{Confidence interval with the Hajek estimator and variance estimator with between-block bias.}
\item{CI_haj_wb}{Confidence interval with the Hajek estimator and variance estimator with within-block bias.}
\item{yht}{The Horvitz-Thompson estimator for each treatment.}
\item{yhaj}{The Hajek estimator for each treatment.}
\item{Sht_bb}{Covariance estimator for the Horvitz-Thompson estimator for each treatment with between-block bias.}
\item{Sht_wb}{Covariance estimator for the Horvitz-Thompson estimator for each treatment with within-block bias.}
\item{Shaj_bb}{Covariance estimator for the Hajek estimator for each treatment with between-block bias.}
\item{Shaj_wb}{Covariance estimator for the Hajek estimator for each treatment with within-block bias.}
\item{alpha}{Confidence level}
}
\description{
Conduct the design-based inference for incomplete block designs.
}
\examples{
K <- 6
n.trt <- 3
t <- 2
n.vec <- rep(4, K)
df <- IBDgen(K = K, n.trt = n.trt, t = t, n.vec = n.vec)$blk_assign
df$y <- rnorm(nrow(df), 0, 1)
IBDInfer <- IBDInfer(y = y, b = blk_id, z = assign, g = c(1, -1, 0), w = "Block", data = df)

}
\references{
{
Koo, T., Pashley, N.E. (2024), Design-based Causal Inference for Incomplete Block Designs, \emph{arXiv preprint arXiv:2405.19312}. \cr
}
}
