% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_aggregated_test_results.R
\name{calculate_aggregated_test_results}
\alias{calculate_aggregated_test_results}
\title{Aggregate test result}
\usage{
calculate_aggregated_test_results(
  p_diff_uptake_conf_dat,
  method = c("significance", "weiss"),
  time_t = 1,
  skip_amino = 1
)
}
\arguments{
\item{p_diff_uptake_conf_dat}{uptake data with confidence, 
as produced by \code{\link{create_p_diff_uptake_dataset_with_confidence}}
function}

\item{method}{method of aggregation: significance or
weiss method}

\item{time_t}{chosen time point}

\item{skip_amino}{\code{integer}, indicator
how many amino acids from the N-terminus should be 
omitted in visualization}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Function aggregates peptide-level
information into residue level. Significance method
indicates if the difference is significant or not -
if the number of significant peptides over this residue 
is bigger than the number of insignificant.
}
\details{
Only peptides without modification are 
aggregated.
}
\examples{
p_diff_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
p_diff_uptake_conf_dat <- create_p_diff_uptake_dataset_with_confidence(p_diff_uptake_dat)
calculate_aggregated_test_results(p_diff_uptake_conf_dat, method = "significance")
calculate_aggregated_test_results(p_diff_uptake_conf_dat, method = "weiss")

}
\seealso{
\code{\link{read_hdx}}
}
