% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_multiple_kernel_search.R
\name{resultsMultipleKernelGreedySearch}
\alias{resultsMultipleKernelGreedySearch}
\title{Returns the results (thus far) of the greedy design search for multiple kernels}
\usage{
resultsMultipleKernelGreedySearch(obj, max_vectors = 9, form = "one_zero")
}
\arguments{
\item{obj}{The \code{greedy_multiple_kernel_experimental_design} object that is currently running the search}

\item{max_vectors}{The number of design vectors you wish to return. \code{NULL} returns all of them. 
This is not recommended as returning over 1,000 vectors is time-intensive. The default is 9.}

\item{form}{Which form should it be in? The default is \code{one_zero} for 1/0's or \code{pos_one_min_one} for +1/-1's.}
}
\description{
Returns the results (thus far) of the greedy design search for multiple kernels
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(20), nrow = 10)
mk = initGreedyMultipleKernelExperimentalDesignObject(
  X,
  max_designs = 4,
  kernel_pre_num_designs = 4,
  num_cores = 1,
  kernel_names = c("mahalanobis", "gaussian"),
  start = TRUE,
  wait = TRUE,
  verbose = FALSE
)
res = resultsMultipleKernelGreedySearch(mk, max_vectors = 2, form = "one_zero")
res$obj_vals
}
}
\author{
Adam Kapelner
}
