% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_statistics.R
\name{print_binomial}
\alias{print_binomial}
\title{Prints descriptive statistics for binomial variables}
\usage{
print_binomial(x, digits = 1, width = 15)
}
\arguments{
\item{x}{Data frame, matrix, or vector containing binomial variables.}

\item{digits}{Integer specifying the number of decimal places for the test
statistic.}

\item{width}{Integer specifying the maximum width for wrapping text.}
}
\value{
A tibble with one row per level for each categorical level containing the following columns:
\describe{
\item{Variables}{Character vector specifying the name of each variable.}
\item{Levels}{Character vector specifying the category level for each variable.}
\item{Statistics}{Character vector combining the frequency count and the percentage for each level.}
}
}
\description{
Calculates and prints frequency counts and percentages for binomial (two-level) categorical variables.
}
\examples{
x <- data.frame(A = sample(c("X", "Y"), 100, replace = TRUE))
print_binomial(x)
print_binomial(x, digits = 2, width = 5)

}
