


rerun <- function(expr, max_attempts = 10) {
  
  if (!is.function(expr)) {
    stop("rerun(): expr must be a function(), not a function call.\n",
         "Use rerun(function() param_emaEM(...))")
  }
  
  for (attempt in 1:max_attempts) {
    result <- tryCatch(expr(), error = function(e) NULL)
    if (!is.null(result)) return(result)
  }
  
  
  return(NULL)
}



