% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindInliers.R
\name{FindInliers}
\alias{FindInliers}
\title{Detect inliers based on unusual frequency of ocurrance}
\usage{
FindInliers(x, t = 3)
}
\arguments{
\item{x}{numerical vector in which inliers are to be detected}

\item{t}{threshold parameter for detecting outlying counts (default value 3)}
}
\value{
index to elements of \code{x} that occur unusually often, if any
}
\description{
Returns an index to elements of a numerical vector whose frequency
is unusually large relative to most elements, applying the
three-sigma edit rule to counts of individual values.  Inliers
often represent data values that are incorrect but consistent
with the overall data distribution, as in the case of
numerically-coded disguised missing data
}
\examples{
x <- seq(-1, 1, length = 100)
x[45:54] <- 0
FindInliers(x)
}
