% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summary.estimate_secondary}
\alias{summary.estimate_secondary}
\title{Summarise results from estimate_secondary}
\usage{
\method{summary}{estimate_secondary}(
  object,
  type = c("compact", "parameters"),
  params = NULL,
  CrIs = c(0.2, 0.5, 0.9),
  ...
)
}
\arguments{
\item{object}{A fitted model object from \code{estimate_secondary()}}

\item{type}{Character string indicating the type of summary to return.
Options are "compact" (default) which returns delay distribution
parameters and scaling factors, or "parameters" for all parameters
or a filtered set.}

\item{params}{Character vector of parameter names to include. Only used
when \code{type = "parameters"}. If NULL (default), returns all parameters.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{...}{Additional arguments (currently unused)}
}
\value{
A \verb{<data.table>} with summary statistics (mean, sd, median,
credible intervals) for model parameters. When \code{type = "compact"},
returns only key parameters (delay distribution parameters and scaling
factors). When \code{type = "parameters"}, returns all or filtered parameters.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns a summary of the fitted secondary model including posterior
parameter estimates with credible intervals.
}
