% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot,Fragility,missing-method}
\alias{plot,Fragility,missing-method}
\alias{plotFragQuantile}
\alias{plotFragDistribution}
\title{Visualization functions (raw signal, fragility matrix)}
\usage{
\S4method{plot}{Fragility,missing}(
  x,
  y,
  groupIndex = NULL,
  maxLabels = 50,
  ranked = FALSE,
  x.lab.size = 10,
  y.lab.size = 10
)

plotFragQuantile(
  frag,
  groupIndex = NULL,
  groupName = "SOZ",
  x.lab.size = 10,
  y.lab.size = 10
)

plotFragDistribution(
  frag,
  groupIndex = NULL,
  groupName = "SOZ",
  bandType = c("SEM", "SD"),
  rollingWindow = 1,
  ranked = FALSE,
  x.lab.size = 10,
  y.lab.size = 10
)
}
\arguments{
\item{x}{Fragility object from \code{calcAdjFrag}}

\item{y}{Not used (for S4 method compatibility)}

\item{groupIndex}{Integer or string. A group of electrodes to mark}

\item{maxLabels}{Integer. Maximum number of labels to show on y-axis. Default is 50. The actual number of labels may be less than this value if there are too many electrodes.}

\item{ranked}{Logical. If TRUE, use the ranked fragility matrix from Fragility object}

\item{x.lab.size}{Numeric. Size of x-axis labels. Default is 4.}

\item{y.lab.size}{Numeric. Size of y-axis labels. Default is 10}

\item{frag}{Fragility object from \code{calcAdjFrag}}

\item{groupName}{Character. Name of the group of electrodes, default is "SOZ"}

\item{bandType}{Character. The type of band to use, either "SEM" or "SD". Default is "SEM".}

\item{rollingWindow}{Integer. Window size for rolling average smoothing. Default is 1 (no smoothing).}
}
\value{
A ggplot object
}
\description{
\code{plot}: plot fragility heatmaps with electrodes marked as soz colored

\code{plotFragQuantile}: Plot Fragility time quantiles for two electrodes groups

\code{plotFragQuantile}: Plot Fragility time distribution for two electrodes groups
}
\examples{

data("pt01EcoG")

## sozNames is the name of the electrodes we assume are in the SOZ
sozNames <- metaData(pt01EcoG)$sozNames

## precomputed fragility object
data("pt01Frag")

## plot the fragility heatmap
plot(pt01Frag, groupIndex = sozNames)

## plot the fragility quantiles
plotFragQuantile(frag = pt01Frag, groupIndex = sozNames)

## plot the fragility distribution
plotFragDistribution(frag = pt01Frag, groupIndex = sozNames)

## plot with smoothing
plotFragDistribution(frag = pt01Frag, groupIndex = sozNames, rollingWindow = 2)

}
