\name{expanded_schaffer}
\alias{expanded_schaffer}
\title{Expanded Schaffer's F6 Function for Benchmarking Optimization Algorithms}

\usage{
expanded_schaffer(x)
}

\arguments{
\item{x}{
  A numeric vector representing the input variables for which the Expanded Schaffer's F6 function is evaluated.
  }
}

\value{
Returns a numeric value representing the evaluation of Expanded Schaffer's F6 function at the input vector \code{x}.
}

\description{
Expanded Schaffer's F6 function is a standard benchmark function used for testing optimization algorithms. It is a highly multimodal function with a global minimum at \code{x = (0, 0, 0, 0)} for 4 dimensions, where the function value is \code{0.5}.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
expanded_schaffer(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
expanded_schaffer(x)

# Contour Plot: Visualizing Expanded Schaffer's F6 Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) expanded_schaffer(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of Expanded Schaffer's F6 Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = expanded_schaffer, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) expanded_schaffer(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Expanded Schaffer's F6 Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
Schaffer, J. D. (1984). Multiple Objective Optimization with Vector Evaluated Genetic Algorithms. In \emph{Proceedings of the First International Conference on Genetic Algorithms}.
}
