% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/login.R
\name{login}
\alias{login}
\title{Login to the EDI repository}
\usage{
login(userId = NULL, userPass = NULL, config = NULL)
}
\arguments{
\item{userId}{(character) User identifier of an EDI data repository account.
If using}

\item{userPass}{(character) Password of \code{userId}}

\item{config}{(character) Path to config.txt, which contains \code{userId}
and \code{userPass} (see details below)}
}
\value{
(character) Temporary (~10 hour) authentication tokens written to
the system variables "EDI_TOKEN" and "AUTH_TOKEN".
}
\description{
Login to the EDI repository
}
\details{
If \code{userId}, \code{userPass}, and \code{config} are NULL, the console
will prompt for credentials.

\code{config}: Supplying credentials in a file named config.txt facilitates
authentication within automated/unassisted processes. Contents of this file
should be new line separated and have the form "<argument> = <value>" (e.g.
userId = myname).
}
\note{
Only works when authenticating with EDI credentials. Does not work
when authenticating with ORCiD, GitHub, or Google credentials.

Be careful not to accidentally share your \code{userId} and \code{userPass}.
Some tips to avoid this:
\itemize{
  \item Don't write code that explicitly lists your credentials.
  \item Don't save your workspace when exiting an R session.
  \item Do store your credentials as environmental variables and reference
  these.
  \item Do use \code{config} but if using version control ensure the
  config.txt file is listed in your .gitignore.
}
If you may have shared your credentials, please reset your password at
\url{https://dashboard.edirepository.org/dashboard/auth/reset_password_init}.
}
\examples{
\dontrun{

# Interactively at the console
login()
#> User name: "my_name"
#> User password: "my_secret"

# Programmatically with function arguments
login(userId = "my_name", userPass = "my_secret")

# Programmatically with a file containing userId and userPass arguments
login(config = paste0(tempdir(), "/config.txt"))
}

}
\seealso{
Other Authentication: 
\code{\link{logout}()}
}
\concept{Authentication}
