% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDISON-package.R
\docType{package}
\name{EDISON-package}
\alias{EDISON}
\alias{EDISON-package}
\title{EDISON: Network reconstruction and changepoint detection for time series}
\description{
Reconstructs networks from time series data using a non-homogeneous,
time-varying dynamic Bayesian network fitted with MCMC. Network segments and
changepoints are inferred concurrently; information-sharing priors can reduce
inference uncertainty.
}
\examples{
# Generate random gene network and simulate data from it
dataset = simulateNetwork(l = 25)

# Running the full MCMC can take time; use a small number of iterations
# for examples. Increase `num.iter` for real analyses.
\donttest{
set.seed(1)
result = EDISON.run(dataset$sim_data, num.iter = 50)

# Posterior probabilities of changepoints
cps = calculateCPProbabilities(result)

# Marginal posterior probabilities of edges
network = calculateEdgeProbabilities(result)
}
}
\references{
Dondelinger et al. (2012). Non-homogeneous dynamic Bayesian networks with
Bayesian regularization for inferring gene regulatory networks with gradually
time-varying structure. *Machine Learning*.

Husmeier et al. (2010). Inter-time segment information sharing for
non-homogeneous dynamic Bayesian networks. *NIPS*.
}
\seealso{
\code{\link[corpcor:corpcor-package]{corpcor}}
}
\author{
\strong{Maintainer}: Frank Dondelinger \email{fdondelinger.work@gmail.com}

Authors:
\itemize{
  \item Sophie Lebre
}

}
\keyword{internal}
