% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{cor_net}
\alias{cor_net}
\title{Correlation and partial correlation networks.}
\usage{
cor_net(
  data,
  index = c("cor", "pcor"),
  show.label = TRUE,
  show.insig = FALSE,
  show.cutoff = FALSE,
  faded = FALSE,
  node.text.size = 1.2,
  node.group = NULL,
  node.color = NULL,
  edge.color.pos = "#0571B0",
  edge.color.neg = "#CA0020",
  edge.color.non = "#EEEEEEEE",
  edge.width.min = "sig",
  edge.width.max = NULL,
  edge.label.mrg = 0.01,
  file = NULL,
  width = 6,
  height = 4,
  dpi = 500,
  ...
)
}
\arguments{
\item{data}{Data.}

\item{index}{Type of graph: \code{"cor"} (raw correlation network) or \code{"pcor"} (partial correlation network). Defaults to \code{"cor"}.}

\item{show.label}{Show labels of correlation coefficients and their significance on edges. Defaults to \code{TRUE}.}

\item{show.insig}{Show edges with insignificant correlations (\emph{p} > 0.05). Defaults to \code{FALSE}. To change significance level, please set \code{alpha} (defaults to \code{alpha=0.05}).}

\item{show.cutoff}{Show cut-off values of correlations. Defaults to \code{FALSE}.}

\item{faded}{Transparency of edges according to the effect size of correlation. Defaults to \code{FALSE}.}

\item{node.text.size}{Scalar on the font size of node (variable) labels. Defaults to \code{1.2}.}

\item{node.group}{A list that indicates which nodes belong together, with each element of list as a vector of integers identifying the column numbers of variables that belong together.}

\item{node.color}{A vector with a color for each element in \code{node.group}, or a color for each node.}

\item{edge.color.pos}{Color for (significant) positive values. Defaults to \code{"#0571B0"} (blue in ColorBrewer's RdBu palette).}

\item{edge.color.neg}{Color for (significant) negative values. Defaults to \code{"#CA0020"} (red in ColorBrewer's RdBu palette).}

\item{edge.color.non}{Color for insignificant values. Defaults to \code{"#EEEEEEEE"} (faded light grey).}

\item{edge.width.min}{Minimum value of edge strength to scale all edge widths. Defaults to \code{sig} (the threshold of significant values).}

\item{edge.width.max}{Maximum value of edge strength to scale all edge widths. Defaults to \code{NULL} (for undirected correlation networks) and \code{1.5} (for directed acyclic networks to better display arrows).}

\item{edge.label.mrg}{Margin of the background box around the edge label. Defaults to \code{0.01}.}

\item{file}{File name of saved plot (\code{".png"} or \code{".pdf"}).}

\item{width, height}{Width and height (in inches) of saved plot. Defaults to \code{6} and \code{4}.}

\item{dpi}{Dots per inch (figure resolution). Defaults to \code{500}.}

\item{...}{Arguments passed on to \code{\link[qgraph:qgraph]{qgraph()}}.}
}
\value{
Return a list (class \code{cor.net}) of (partial) correlation results and \code{\link[qgraph:qgraph]{qgraph}} object.
}
\description{
Correlation and partial correlation networks (also called Gaussian graphical models, GGMs).
}
\examples{
\donttest{# correlation network
cor_net(airquality)
cor_net(airquality, show.insig=TRUE)

# partial correlation network
cor_net(airquality, "pcor")
cor_net(airquality, "pcor", show.insig=TRUE)

# modify ggplot attributes
p = cor_net(airquality, "pcor")
gg = plot(p)  # return a ggplot object
gg + labs(title="Partial Correlation Network")
}
}
\seealso{
\link{S3method.network}

\code{\link[=DPI_dag]{DPI_dag()}}

\code{\link[=BNs_dag]{BNs_dag()}}
}
