% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCV_function.r
\name{MST_Edges}
\alias{MST_Edges}
\title{Function that finds the list of MST edges}
\usage{
MST_Edges(G, start, G_edges_weights)
}
\arguments{
\item{G}{list of four elements: number of vertices, MST_edges (matrix of edges),
MST_degrees (array of numbers), MST_parent (array of numbers)}

\item{start}{index of the first edge}

\item{G_edges_weights}{matrix of edges weights}
}
\value{
list of two elements: matrix of edges and array of degrees
}
\description{
Function that finds the list of MST edges
}
\examples{

n = 300; noise = 0.05;
seed = 1782;
theta <- seq(0, pi, length.out = n / 2)
x1 <- cos(theta) + rnorm(n / 2, sd = noise)
y1 <- sin(theta) + rnorm(n / 2, sd = noise)
x2 <- cos(theta + pi) + rnorm(n / 2, sd = noise)
y2 <- sin(theta + pi) + rnorm(n / 2, sd = noise)
X <- rbind(cbind(x1, y1), cbind(x2, y2))
 y <- c(rep(0, n / 2), rep(1, n / 2))

nfeatures <- ncol(X)
i <- 1
clusters <- unique(y)
objcl <- which(y == clusters[i])
nuobjcl <- length(objcl)

noiseLabel <- -1
distX <- as.matrix(dist(X))^2
distXy <- distX[y != noiseLabel, y != noiseLabel]

mr <- matrix_mutual_reachability_distance(nuobjcl, distXy[objcl, objcl], nfeatures)

d_ucore_cl <- rep(0, nrow(X))
d_ucore_cl[objcl] <- mr$d_ucore
G <- list(no_vertices = nuobjcl, MST_edges = matrix(0, nrow = nuobjcl - 1, ncol = 3),
         MST_degrees = rep(0, nuobjcl), MST_parent = rep(0, nuobjcl))
g_start <- 1

mst_results <- MST_Edges(G, g_start, mr$G_edges_weights)

}
