% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_endemic_clade.R
\name{extract_endemic_clade}
\alias{extract_endemic_clade}
\title{Extracts the information for an endemic clade (i.e. more than one species on
the island more closely related to each other than other mainland species)
from a phylogeny (specifically \code{phylo4d}  object from \code{phylobase} package)
and stores it in an \code{Island_colonist} class}
\usage{
extract_endemic_clade(phylod, species_label, unique_clade_name)
}
\arguments{
\item{phylod}{A \code{phylo4d} object from the package \code{phylobase} containing
phylogenetic and endemicity data for each species.}

\item{species_label}{The tip label of the species of interest.}

\item{unique_clade_name}{Boolean determining whether a unique species
identifier is used as the clade name in the Island_tbl object or a genus
name which may not be unique if that genus has several independent island
colonisations}
}
\value{
An object of \code{Island_colonist} class
}
\description{
Extracts the information for an endemic clade (i.e. more than one species on
the island more closely related to each other than other mainland species)
from a phylogeny (specifically \code{phylo4d}  object from \code{phylobase} package)
and stores it in an \code{Island_colonist} class
}
\examples{
set.seed(
  3,
  kind = "Mersenne-Twister",
  normal.kind = "Inversion",
  sample.kind = "Rejection"
)
phylo <- ape::rcoal(10)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                     "bird_f", "bird_g", "bird_h", "bird_i", "bird_j")
phylo <- methods::as(phylo, "phylo4")
endemicity_status <- sample(
  x = c("not_present", "endemic", "nonendemic"),
  size = length(phylobase::tipLabels(phylo)),
  replace = TRUE,
  prob = c(0.7, 0.3, 0)
)
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
island_colonist <- extract_endemic_clade(
  phylod = phylod,
  species_label = "bird_i",
  unique_clade_name = TRUE
)
}
