% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{EventAssignment.poisresbound}
\alias{EventAssignment.poisresbound}
\title{Predicts how many events are due to baseline vs excess for a completed poisson likelihood boundary regression}
\usage{
\method{EventAssignment}{poisresbound}(
  x,
  df,
  assign_control = list(),
  control = list(),
  a_n = c(),
  ...
)
}
\arguments{
\item{x}{result object from a regression, class poisres}

\item{df}{a data.table containing the columns of interest}

\item{assign_control}{control list for bounds calculated}

\item{control}{list of parameters controlling the convergence, see the Control_Options vignette for details}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}

\item{...}{can include the named entries for the assign_control list parameter}
}
\value{
returns a list of the final results
}
\description{
\code{EventAssignment.poisresbound} uses user provided data, person-year/event columns, vectors specifying the model,
and options to calculate background and excess events for a solved Poisson regression
}
\seealso{
Other Poisson Wrapper Functions: 
\code{\link{EventAssignment.poisres}()},
\code{\link{LikelihoodBound.poisres}()},
\code{\link{PoisRun}()},
\code{\link{PoisRunJoint}()},
\code{\link{PoisRunMulti}()},
\code{\link{Residual.poisres}()}
}
\concept{Poisson Wrapper Functions}
