% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC_new.R
\name{PPC_new}
\alias{PPC_new}
\title{Center-then-PCA: Projection on the Orthogonal Complement of the Mean Vector}
\usage{
PPC_new(data, m)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p).}

\item{m}{Integer. The number of principal components (factors) to keep.}
}
\value{
A list containing:
\item{Apro}{Estimated factor loading matrix (p x m).}
\item{Dpro}{Estimated residual variances (p x p diagonal matrix).}
\item{Sigmahatpro}{Covariance matrix of the projected data.}
}
\description{
This function performs a specific type of Projected PCA where the data is projected onto
the orthogonal complement of the mean vector. It effectively applies the centering projection
\eqn{P = I - (1/n)J} (where \eqn{J} is the all-ones matrix), optionally rescales the columns,
and then performs PCA on the covariance matrix. This allows estimation of factor loadings and
residual variances after removing the mean structure.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(1)
dat <- matrix(stats::rnorm(200), ncol = 4)
ans <- PPC_new(data = dat, m = 2)
str(ans)
head(ans$Apro)
}
