% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ch_safe_GET}
\alias{ch_safe_GET}
\title{Executes GET function with error trapping}
\usage{
ch_safe_GET(url = NULL, filename = NULL)
}
\arguments{
\item{url}{Required. URL to be accessed.}

\item{filename}{Required. File to be used to save data}
}
\value{
Returns a character string: "OK" if all went well, the error message
if it did not.
}
\description{
Executes GET function with error trapping
}
\examples{
\donttest{
# Not tested automatically as can be very slow
test_url <- "https://zenodo.org/record/4781469/files/sm_data.csv"
dir_name <- tempdir(check = FALSE)
if (!dir.exists(dir_name)) {
  dir.create(dir_name, recursive = TRUE)
}
test_file <- file.path(dir_name, "gs_dem25.tif")
result <- ch_safe_GET(test_url, test_file)
}

}
\author{
Kevin Shook
}
\keyword{internal}
