% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSegs.R
\name{plotSegs}
\alias{plotSegs}
\title{plotSegs}
\usage{
plotSegs(
  samples,
  name = "",
  chrom = -1,
  gbuild = "hg19",
  sep = FALSE,
  alpha = 1
)
}
\arguments{
\item{samples}{The samples to plot. If a list it plots both on the same plot}

\item{name}{The name of the sample. Used for plot title}

\item{chrom}{Which chromosome to plot. Default plots all of them.}

\item{gbuild}{The reference genome build. Default is hg19. Also supports hg18 and hg38.}

\item{sep}{Whether or not to place different members of the list on the same
or different axis}

\item{alpha}{Allows you to adjust the transparency of the lines. 0-1}
}
\value{
displays a plot of the segments
}
\description{
This function is used to create a plot of a samples segs. The input samples
can either be a single data.frame of the segs of one patient or a list of
data.frames for multiple samples.
}
\examples{
plotSegs(segDataExp[[1]]) #Plots all of the first sample's segments
plotSegs(segDataExp[[1]],1) #Only plots the first chromosome segments
plotSegs(segDataExp[1:2]) #Plots first two samples on same axis
plotSegs(segDataExp[1:2], sep = TRUE) #Plots first two samples seperately
}
\keyword{plot}
\keyword{segments}
