% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPMD.R
\name{plotPMD}
\alias{plotPMD}
\title{Plot Posterior Mean Difference (PMD) Distributions}
\usage{
plotPMD(o, o2 = NULL)
}
\arguments{
\item{o}{An object produced by the \code{power.DPP()} function.}

\item{o2}{(Optional) A second object from \code{power.DPP()} to compare on the
same plot. Default is \code{NULL}.}
}
\value{
Invisibly returns a list containing summary statistics. The
structure of the list depends on whether \code{o2} is provided.
\itemize{
\item{If \code{o2} is \code{NULL}}: A list with a scalar \code{mean_PMD}, a scalar
\code{sd_PMD}, and a numeric vector \code{CI95_PMD}.
\item{If \code{o2} is provided}: A list with numeric vectors for \code{mean_PMD}
and \code{sd_PMD}, and a matrix for \code{CI95_PMD}, with each row
corresponding to an input object.
}
}
\description{
Plots the density of the posterior mean difference between the hybrid and
concurrent control arms, based on an object from \code{power.DPP()}. Can
compare one or two such objects on the same plot.
}
\examples{
# nsim reduced for faster example
o1a <- power.DPP(pt=0.65, nt=60, pc=0.45, nc=30, pc.calib=0.45,
                 pch=0.45, nche=60, nch=200, alpha=0.1, nsim=1000)
o1b <- power.DPP(pt=0.65, nt=60, pc=0.45, nc=30, pc.calib=0.45,
                 pch=0.45, nche=30, nch=200, alpha=0.1, nsim=1000)

# Plot a single object
stats1 <- plotPMD(o=o1a)

# Plot two objects for comparison
stats2 <- plotPMD(o=o1a, o2=o1b)

}
