#' @references Yu, W., & Bondell, H. D. (2023), “Bayesian Likelihood-Based Regression
#' for Estimation of Optimal Dynamic Treatment Regimes”, Journal of the Royal
#' Statistical Society Series B: Statistical Methodology, 85(3), 551-574.
#' \doi{doi:10.1093/jrsssb/qkad016}
#' @seealso [generate_dataset()] for generating a toy dataset to test the model fitting on
#' @seealso [BayesLinRegDTR.model.fit()] for obtaining an estimated posterior
#' distribution of the optimal treatment option at a user-specified prediction stage
#' @seealso Useful links:
#' \itemize{
#'     \item \url{https://github.com/jlimrasc/BayesRegDTR}
#'     \item Report bugs at \url{https://github.com/jlimrasc/BayesRegDTR/issues}
#' }
"_PACKAGE"

## usethis namespace: start
#' @importFrom doRNG %dorng%
#' @importFrom foreach %dopar%
## usethis namespace: end
NULL
