% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_ermod_lin.R
\name{dev_ermod_bin_cov_sel}
\alias{dev_ermod_bin_cov_sel}
\alias{dev_ermod_lin_cov_sel}
\title{Perform covariate selection for linear ER model}
\usage{
dev_ermod_bin_cov_sel(
  data,
  var_resp,
  var_exposure,
  var_cov_candidates,
  cv_method = c("LOO", "kfold"),
  k = 5,
  validate_search = FALSE,
  nterms_max = NULL,
  .reduce_obj_size = TRUE,
  prior = rstanarm::default_prior_coef(stats::binomial()),
  prior_intercept = rstanarm::default_prior_intercept(stats::binomial()),
  verbosity_level = 1,
  chains = 4,
  iter = 2000
)

dev_ermod_lin_cov_sel(
  data,
  var_resp,
  var_exposure,
  var_cov_candidates,
  cv_method = c("LOO", "kfold"),
  k = 5,
  validate_search = FALSE,
  nterms_max = NULL,
  .reduce_obj_size = TRUE,
  prior = rstanarm::default_prior_coef(stats::binomial()),
  prior_intercept = rstanarm::default_prior_intercept(stats::binomial()),
  prior_aux = rstanarm::exponential(autoscale = TRUE),
  verbosity_level = 1,
  chains = 4,
  iter = 2000
)
}
\arguments{
\item{data}{Input data for E-R analysis}

\item{var_resp}{Response variable name in character}

\item{var_exposure}{Exposure variable names in character}

\item{var_cov_candidates}{Candidate covariate names in character vector}

\item{cv_method}{Cross-validation method. Default is "LOO" (recommended).
Use "kfold" if you see warnings on Pareto k estimates.}

\item{k}{Number of folds for kfold CV.
Only used if cv_method is "kfold".}

\item{validate_search}{Whether to validate the search. Default is FALSE.
Recommend to set to TRUE for kfold CV. Do not use for LOO (run time would
become too long).}

\item{nterms_max}{Maximum number of terms to consider in the model.
Default is NULL (all terms are considered).}

\item{.reduce_obj_size}{Whether to reduce object size by removing some
elements from projpred outputs that are not necessary for the functionality
of this package.}

\item{prior, prior_intercept, prior_aux}{See \code{\link[rstanarm:stan_glm]{rstanarm::stan_glm()}}}

\item{verbosity_level}{Verbosity level. 0: No output, 1: Display steps,
2: Display progress in each step, 3: Display MCMC sampling.}

\item{chains}{Number of chains for Stan.}

\item{iter}{Number of iterations for Stan.}
}
\value{
An object of class \code{ermod_bin_cov_sel} or \code{ermod_lin_cov_sel}.
}
\description{
This functions is used to develop an ER model with covariates for binary
and continuous endpoints.
\code{projpred} package is used for variable selection.
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_covsel()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

er_binary_cov_model <- dev_ermod_bin_cov_sel(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov_candidates = c(
    "BAGE_10", "BWT_10", "BGLUC",
    "BHBA1C_5", "RACE", "VISC"
  )
)

er_binary_cov_model
}
\dontshow{\}) # examplesIf}
\dontshow{if (BayesERtools:::.if_run_ex_covsel()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_lin)

ermod_lin_cov_sel <- dev_ermod_lin_cov_sel(
  data = d_sim_lin,
  var_resp = "response",
  var_exposure = "AUCss",
  var_cov_candidates = c("BAGE", "SEX")
)

ermod_lin_cov_sel
}
\dontshow{\}) # examplesIf}
}
