% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StartValues.R
\name{startValues}
\alias{startValues}
\title{Starting values for optimization functions}
\usage{
startValues(model = "explore", p = NULL, digits = 2, ...)
}
\arguments{
\item{model}{Selects the functional form of the boundary line. It includes
\code{"blm"} for linear model, \code{"lp"} for
linear plateau model, \code{"mit"} for the Mitscherlich model, \code{"schmidt"}
for the Schmidt model, \code{"logistic"} for logistic model, \code{"logisticND"}
for logistic model proposed by Nelder (1961), \code{"inv-logistic"} for
the inverse logistic model, \code{"double-logistic"} for the double logistic model,
\code{"qd"} for quadratic model, \code{"trapezium"} for the trapezium model and
\code{"explore"} for function use exploration. The default is \code{"explore"}.}

\item{p}{The number of selected points used to obtain start values for the logistic
mitcherlich and schmidt models. It is \code{NULL} for other models.}

\item{digits}{Number of decimal points for logistic type models (default is 2).}

\item{...}{Additional graphical parameters. Applies to the logistic, mitcherlich and
schmidt models to control the text on the plot.}
}
\value{
A list containing the parameters of the suggested model.
}
\description{
This functions helps to determine initial values for a selected boundary line
model when using the functions \code{blbin()}, \code{blqr()}, \code{bolides()},
\code{cbvn()} and \code{ble_profile()} to determine model parameters.
}
\details{
This function uses the \code{locator()} function. Once the model is selected,
the points that make up the boundary points are selected using mouse click on
the plots.
}
\examples{
startValues(model="explore")


}
\references{
Fekedulegn, D., Mac Siurtain, M.P., & Colbert, J.J. 1999. Parameter estimation of
nonlinear growth models in forestry. Silva Fennica 33(4): 327–336.

Lark, R. M., & Milne, A. E. (2016). Boundary line analysis of the effect of water
filled pore space on nitrous oxide emission from cores of arable soil. European
Journal of Soil Science, 67 , 148-159.
}
\author{
Chawezi Miti <chawezi.miti@nottingham.ac.uk>
}
