% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_time_out_success.R
\name{do_time_out_success}
\alias{do_time_out_success}
\title{Check if timeouts resulted in scoring}
\usage{
do_time_out_success(data, day_num, game_code, team_sel, verbose)
}
\arguments{
\item{data}{Prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code}{Game code.}

\item{team_sel}{One of the teams' names involved in the game.}

\item{verbose}{Logical. Decide if information of the computations
must be provided or not.}
}
\value{
Data frame.  This is the meaning of the columns:
\itemize{
  \strong{day}: Day number.
  \strong{game_code}: Game code.
  \strong{team}: Name of the corresponding team and coach.
  \strong{times_out_requested}: Number of timeouts requested in the game.
  \strong{times_out_successful}: Number of timeouts that resulted in scoring.
  \strong{times_out_successful_perc}: Percentage of successful timeouts.
  \strong{points_scored}: Total of points achieved after the timeouts.
}
}
\description{
For each team, locate the position of timeouts and check if they 
resulted in scoring points.
}
\examples{
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

df1 <- do_prepare_data_to(df0, TRUE, acb_games_2223_info, acb_games_2223_coach)

# sort(unique(df1$team))
# "Casademont Zaragoza_Porfirio Fisac" "Valencia Basket_Alex Mumbru"

df2 <- do_time_out_success(df1, day_num, game_code, 
                           "Casademont Zaragoza_Porfirio Fisac", FALSE)
#df2

}
\seealso{
\code{\link{do_prepare_data_to}}
}
\author{
Guillermo Vinue
}
