% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_hist}
\alias{plot_hist}
\title{Create a ggplot2 histogram of a \code{RasterLayer}.}
\usage{
plot_hist(
  x,
  mask.obj = NULL,
  add.mean = FALSE,
  add.median = FALSE,
  save.dir = "",
  binwidth = 0.05,
  title = NULL
)
}
\arguments{
\item{x}{\code{RasterLayer} object containing the spatial data.}

\item{mask.obj}{\code{RasterLayer} object optionally used for masking
only specific parts of \code{x}.}

\item{add.mean}{Boolean whether a vertical blue line is added to the
plot indicating the mean value of \code{x}.}

\item{add.median}{Boolean whether a vertical red line is added to the
plot indicating the median value of \code{x}.}

\item{save.dir}{Character path (folder) for saving the plot as an
image.}

\item{binwidth}{Double value of bindwidth for \code{\link{geom_bar}}.}

\item{title}{Character string title of the plot.}
}
\value{
a \code{ggplot} object containing the plot.
}
\description{
Create a ggplot2 histogram of a \code{RasterLayer}.
}
\seealso{
\code{\link{geom_bar}}.
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
