% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_prior.R
\name{fit_prior}
\alias{fit_prior}
\title{Find appropriate standard deviations for prior}
\usage{
fit_prior(n_bins, n_draws = 10000, target = 1/n_bins, iterations = 5)
}
\arguments{
\item{n_bins}{Bins for the Dirichlet distribution}

\item{n_draws}{Numbers of samples to use for doing calculation}

\item{target}{The goal of the specified prior, e.g. 1 or 1/n_bins}

\item{iterations}{to try, to ensure robust solution. Defaults to 5}
}
\value{
A 3-element list consisting of \code{sd} (the approximate standard deviation
in transformed space that gives a similar prior to that specified), \code{value} (the
value of the root mean squared percent error function being minimized),
and \code{convergence} (0 if convergence occurred, error code from
\code{\link[=optim]{optim()}} otherwise)
}
\description{
Find appropriate standard deviations for prior
}
\examples{
\donttest{
# fit model with 3 components / alpha = 1
set.seed(123)
f <- fit_prior(n_bins = 3, n_draws = 1000, target = 1)
# fit model with 20 components / alpha = 1/20
f <- fit_prior(n_bins = 20, n_draws = 1000, target = 1 / 20)
}

}
