% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-preparation.R
\name{zcurve_data}
\alias{zcurve_data}
\title{Prepare data for z-curve}
\usage{
zcurve_data(data, id = NULL, rounded = TRUE, stat_precise = 2, p_precise = 3)
}
\arguments{
\item{data}{a vector strings containing the test statistics.}

\item{id}{a vector identifying observations from the same cluster.}

\item{rounded}{an optional argument specifying whether de-rounding should be applied.
Defaults to \code{FALSE} to treat all input as exact values or a numeric
vector with values specifying precision of the input. The other option,
\code{FALSE}, automatically extracts the number of decimals from input
and treats the input as censored if it does not surpass the \code{stat_precise} and
the \code{p_precise} thresholds.}

\item{stat_precise}{an integer specifying the numerical precision of
\code{"z", "t", "f"} statistics treated as exact values.}

\item{p_precise}{an integer specifying the numerical precision of
p-values treated as exact values.}
}
\value{
An object of type \code{"zcurve_data"}.
}
\description{
\code{zcurve_data} is used to prepare data for the
\code{\link[=zcurve]{zcurve()}} function. The function transform strings containing
reported test statistics \code{"z", "t", "f", "chi", "p"} into two-sided
p-values. Test statistics reported as inequalities are as considered
to be censored as well as test statistics reported with low accuracy
(i.e., rounded to too few decimals). See details for more information.
}
\details{
By default, the function extract the type of test statistic:
\itemize{
\item{\code{"F(df1, df2)=x"}}{F-statistic with df1 and df2 degrees of freedom,}
\item{\code{"chi(df)=x"}}{Chi-square statistic with df degrees of freedom,}
\item{\code{"t(df)=x"}}{for t-statistic with df degrees of freedom,}
\item{\code{"z=x"}}{for z-statistic,}
\item{\code{"p=x"}}{for p-value.}
}
The input is not case sensitive and automatically removes empty spaces. Furthermore,
inequalities (\code{"<"} and \code{">"}) can be used to denote censoring. I.e., that
the p-value is lower than \code{"x"} or that the test statistic is larger than \code{"x"}
respectively. The automatic de-rounding procedure (if \code{rounded = TRUE}) treats
p-values with less decimal places than specified in \code{p_precise} or test statistics
with less decimal places than specified in \code{stat_precise} as censored on an interval
that could result in a given rounded value. I.e., a \code{"p = 0.03"} input would be
de-rounded as a p-value lower than 0.035 but larger than 0.025.
}
\examples{
# Specify a character vector containing the test statistics
data <- c("z = 2.1", "t(34) = 2.21", "p < 0.03", "F(2,23) > 10", "p = 0.003")

# Obtain the z-curve data object
data <- zcurve_data(data)

# inspect the resulting object
data
}
\seealso{
\code{\link[=zcurve]{zcurve()}}, \code{\link[=print.zcurve_data]{print.zcurve_data()}}, \code{\link[=head.zcurve_data]{head.zcurve_data()}}
}
