% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_by_flattening.R
\name{simplify_by_flattening}
\alias{simplify_by_flattening}
\title{Simplify the structure of extracted YAML fragments}
\usage{
simplify_by_flattening(x, simplify = ".*", .level = 1)
}
\arguments{
\item{x}{Extracted (and loaded) YAML fragments}

\item{simplify}{A regular expression specifying which elements to
simplify (default is everything)}

\item{.level}{Internal argument to enable slightly-less-than-elegant 'recursion'.}
}
\value{
A simplified list (but still a list)
}
\description{
This function does some cleaning and simplifying to allow
efficient specification of elements in the YAML fragments.
}
\examples{
yamlFragmentExample <- '
---
source:
  -
    id: src_1
    label: "Label 1"
  -
    id: src_2
    label: "Label 2"
assertion:
  -
    id: assertion_1
    label: "Assertion 1"
  -
    id: assertion_2
    label: "Assertion 2"
---
';
loadedExampleFragments <-
  load_yaml_fragments(yamlFragmentExample);
simplified <-
  simplify_by_flattening(loadedExampleFragments);

### Pre simmplification:
str(loadedExampleFragments);

### Post simmplification:
str(simplified);

}
