% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findChain.R
\name{findChain}
\alias{findChain}
\title{Chain Calculator}
\usage{
findChain(pathFileInput = NULL, pathDirOutput = NULL, ...)
}
\arguments{
\item{pathFileInput}{Path of the input csv file generated from MaxQuant. \cr
\cr
MaxQuant is a quantitative proteomics software designed to analyze large mass-spectrometric data. The input of MaxQuant is a
raw file (.raw) from high-resolution mass spectrometers. After analysis of the raw file in MaxQuant, the program generates a
folder named “combined”. \cr
\cr
In this folder there is another folder named “txt” which contains many files with text format (.txt). One of the files called
“peptides” which is the input of the ypssc to calculate secondary structures. ypssc has been designed such a way that can
analyzed and extract information regarding the sample regardless of the name that user chosen for the sample.}

\item{pathDirOutput}{Path of the directory to which the output files will be generated.}

\item{...}{(for developer use only)}
}
\value{
The output of the program is a csv file (.csv) that contains 5 columns, and the number of rows depends on the number of
proteins in the sample. \cr
\cr
First column contains the ID of the identified alpha-helix proteins in the sample, second column contains the number of identified
amino acids from the corresponding protein, third column contains number of identified amino acids with secondary structure,
fourth column contains the number of amino acids that the protein originally has in the SSDYP, and fifth column contains the
number of amino acids in chain structure that the protein originally has in the SSDYP. \cr
\cr
These columns should provide all information that the user needs to know about the protein and its structural information as
well as structural information about the parts of the protein that has been identified in the sample. \cr
\cr
In addition, it also generates 4 more '.csv' files. \cr
\enumerate{
\item The no. of proteins found in the sample. \cr
\item The no. of peptides found in the sample. \cr
\item The no. of amino acids for each protein in database. \cr
\item It is the input file from MaxQuant that's been cleaned up for the sole purpose of calculating secondary structures.
}
}
\description{
Form bottom-up proteomics data of proteins (peptides), this function determines the sections of proteins (in
percentage) with primary, structure.
}
\examples{
\dontrun{
findChain( pathFileInput = "some/path/to/inputFile.csv",
           pathDirOutput = "some/path/to/outputDir/" )

findChain()
}
}
\seealso{
\code{\link{findSecondary}}, \code{\link{findAlpha}}, \code{\link{findBeta}}
}
