% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlersVsBatsmenAllOppnAllMatchesPlot.R
\name{teamBowlersVsBatsmenAllOppnAllMatchesPlot}
\alias{teamBowlersVsBatsmenAllOppnAllMatchesPlot}
\title{Plot bowlers vs batsmen against all opposition all matches}
\usage{
teamBowlersVsBatsmenAllOppnAllMatchesPlot(bowlerDF,t1,t2)
}
\arguments{
\item{bowlerDF}{The data frame of the bowler whose performance is required}

\item{t1}{The team against to which the player belong}

\item{t2}{The opposing team}
}
\value{
none
}
\description{
This function computes performance of bowlers of a team against all opposition in all matches
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India and all oppostions
matches <-getAllMatchesAllOpposition("India",dir="../data/",save=TRUE)

#Get the details of the bowler with the specified rank as a dataframe
df <- teamBowlersVsBatsmenAllOppnAllMatchesRept(matches,theTeam="India",rank=1)
#Plot this
teamBowlersVsBatsmenAllOppnAllMatchesPlot(df,"India","India")

df <- teamBowlersVsBatsmenAllOppnAllMatchesRept(matches,theTeam="England",rank=1)
teamBowlersVsBatsmenAllOppnAllMatchesPlot(df,"India","England")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesMain}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesRept}}\cr
}
\author{
Tinniam V Ganesh
}
