% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAllMatchesAllOpposition.R
\name{getAllMatchesAllOpposition}
\alias{getAllMatchesAllOpposition}
\title{Get data on all matches against all opposition}
\usage{
getAllMatchesAllOpposition(team,dir=".",save=FALSE,odir=".")
}
\arguments{
\item{team}{The team for which all matches and all opposition has to be obtained e.g. India, Pakistan}

\item{dir}{The input directory}

\item{save}{Default=FALSE. This parameter indicates whether the combined data frame needs to be saved or not. It is recommended
to save this large dataframe as the creation of this data frame takes a several seconds depending
on the number of matches}

\item{odir}{The output directory}
}
\value{
match
The combined data frame
}
\description{
This function gets all the matches for a particular team for e.g India, Pakistan,
Australia etc against all other oppositions. It constructs a huge dataframe of all these
matches. This can be saved by the user which can be used in function in which analyses are
done for all matches and for all oppositions. This is done by loading the saved .RData for
each match and performing an rbind of the data frames for each match
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches for team India
getAllMatchesAllOpposition("India",dir="../data/",save=TRUE)
getAllMatchesAllOpposition("Australia",dir="./mysavedata/",save=TRUE)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{bowlerMovingAverage}}\cr
\code{\link{bowlerWicketPlot}}\cr
\code{\link{bowlerWicketsVenue}}\cr
\code{\link{bowlerMeanRunsConceded}}\cr
}
\author{
Tinniam V Ganesh
}
